CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
    IF  NOT EXISTS (SELECT 1 FROM information_schema.columns 
                    WHERE table_name= 'pdv_vd' 
                         and column_name='flag_nfce') THEN 
		ALTER TABLE pdv_vd ADD COLUMN flag_nfce int DEFAULT(0);
        RAISE NOTICE 'Operacao realizada com sucesso.';
    ELSE 
		RAISE NOTICE 'Coluna flag_nfce na tabela pdv_vd EXISTE.'; 
    END IF;
	
	IF EXISTS (SELECT 1 FROM pg_views 
                    WHERE viewname = 'v_pdv_cupom_mapa_resumo_cx') THEN 
		DROP VIEW IF EXISTS v_pdv_cupom_mapa_resumo_cx;
        RAISE NOTICE 'v_pdv_cupom_mapa_resumo_cx removida.';
    END IF; 
	
	CREATE OR REPLACE VIEW public.v_pdv_cupom_mapa_resumo_cx AS 
		SELECT temp.cd_emp,
			temp.cd_filial,
			temp.cd_cx,
			temp.dt_cupom AS dt_mov,
			COALESCE(pos_ecf.cont_reducao_z, 0::numeric) AS cont_reducao_z,
			COALESCE(pos_ecf.cont_reinicio_op, 0::numeric) AS cont_reinicio_op,
			COALESCE(pos_ecf.vl_gt_ini, 0::numeric) AS vlr_gt_ini,
			COALESCE(pos_ecf.vl_gt_fin, 0::numeric) AS vlr_gt_fin,
			COALESCE((select mov_ant.coo_fin + 1 from pdv_pos_diaria_ecf mov_ant where 
						mov_ant.cd_cx = temp.cd_cx and mov_ant.dt_mov = (select max(dt_mov) from pdv_pos_diaria_ecf 
						where cd_cx = mov_ant.cd_cx and dt_mov < temp.dt_cupom )),1)::numeric as coo_inicial,
			pos_ecf.coo_fin::numeric AS coo_final,
			COALESCE(sum(temp.vlr_contab), 0::numeric) AS vlr_contab,
			COALESCE(sum(temp.vlr_it_cancel), 0::numeric) AS vlr_it_cancel,
			COALESCE(sum(temp.vlr_cupons_cancelados), 0::numeric) AS vlr_cupons_cancelados,
			COALESCE(sum(temp.vlr_cupons_cancelados), 0::numeric) + COALESCE(sum(temp.vlr_it_cancel), 0::numeric) AS vlr_cancelamentos,
			COALESCE(sum(temp.vlr_cupons_cancelados_issqn), 0::numeric) + COALESCE(sum(temp.vlr_it_cancel_issqn), 0::numeric) AS vlr_cancelamentos_issqn,
			COALESCE(sum(temp.vlr_desc_it), 0::numeric) - COALESCE(sum(temp.vl_desc_vd), 0::numeric) AS vlr_desc_it,
			COALESCE(sum(temp.vlr_desc_it_issqn), 0::numeric) AS vlr_desc_issqn,
			COALESCE(sum(temp.vl_desc_vd), 0::numeric) AS vlr_desc_vd,
			COALESCE(sum(temp.vlr_desc_it), 0::numeric, 0::numeric) AS vlr_descontos,
			COALESCE(sum(temp.vlr_vd_liq), 0::numeric) AS vlr_vd_liq,
			COALESCE(trib.vlr_subst_trib, 0::numeric) AS vlr_subst_trib,
			COALESCE(trib.vlr_isentas, 0::numeric) AS vlr_isentas,
			COALESCE(trib.vlr_n_incidencia, 0::numeric) AS vlr_n_incidencia,
			COALESCE(trib.vlr_base_calc_icms, 0::numeric) AS vlr_base_calc_icms,
			COALESCE(trib_taxas.vlr_imposto::double precision, 0::double precision) AS vlr_imposto,
			COALESCE(trib_taxas.tx_icms_it, 0::numeric) AS tx_icms_it,
			COALESCE(trib_taxas.tipo_imposto, 0::numeric) AS tipo_imposto,
			COALESCE(trib_taxas.vlr_tot_base, 0::numeric) AS vlr_tot_base,
			COALESCE(trib_taxas.vlr_tot_base_iss, 0::numeric) AS vlr_tot_base_iss,
			COALESCE(sum(temp.vlr_to_issqn), 0::numeric) AS vlr_to_issqn,
			COALESCE(trib.vlr_subst_trib_iss, 0::numeric) AS vlr_subst_trib_iss,
			COALESCE(trib.vlr_isentas_iss, 0::numeric) AS vlr_isentas_iss,
			COALESCE(trib.vlr_n_incidencia_iss, 0::numeric) AS vlr_n_incidencia_iss,
			COALESCE(trib.vlr_base_calc_icms_iss, 0::numeric) AS vlr_base_calc_icms_iss,
			COALESCE(trib.vlr_imposto_iss::double precision, 0::double precision) AS vlr_imposto_iss,
			COALESCE(sum(temp.vlr_vd_bruta), 0::numeric) AS vlr_vd_bruta
		FROM ( SELECT c.cd_emp,
				c.cd_filial,
				c.cd_cx,
				c.cd_vd AS cd_ctr,
				c.dt_vd AS dt_cupom,
				c.nr_ecf AS coo,
				c.vlr_desc AS vl_desc_vd,
				( SELECT (case when c.flag_nfce  = 1 then COALESCE(sum(it.vlr_liq_it - it.vlr_desc_tot_rat), 0::numeric) else   COALESCE(sum(it.vlr_tot_it - it.vlr_desc_tot_rat), 0::numeric) end) AS "coalesce"
					   FROM pdv_vd_it it
					  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND it.tipo_imposto = 0::numeric AND it.st_it = 1::numeric AND c.st_vd = 0::numeric) AS vlr_contab,

				( SELECT (case when c.flag_nfce  = 1 then COALESCE(sum(it.vlr_liq_it - it.vlr_desc_tot_rat), 0::numeric) else COALESCE(sum(it.vlr_tot_it - it.vlr_desc_tot_rat), 0::numeric) end) AS "coalesce"
					   FROM pdv_vd_it it
					  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND it.tipo_imposto = 0::numeric AND it.st_it = 1::numeric AND c.st_vd = 0::numeric) AS vlr_vd_liq,
				( SELECT COALESCE(sum(it.vlr_tot_it), 0::numeric) AS "coalesce"
					   FROM pdv_vd_it it
					  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND it.st_it = 2::numeric AND c.st_vd = 0::numeric AND it.tipo_imposto = 0::numeric) AS vlr_it_cancel,
				( SELECT COALESCE(sum(it.vlr_tot_it), 0::numeric) AS "coalesce"
					   FROM pdv_vd_it it
					  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND it.st_it = 2::numeric AND c.st_vd = 0::numeric AND it.tipo_imposto = 1::numeric) AS vlr_it_cancel_issqn,
				( SELECT COALESCE(sum(it.vlr_it * it.qt_it), 0::numeric) AS "coalesce"
					   FROM pdv_vd_it it
					  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND c.st_vd = 1::numeric AND it.tipo_imposto = 0::numeric) AS vlr_cupons_cancelados,
				( SELECT COALESCE(sum(it.vlr_it * it.qt_it), 0::numeric) AS "coalesce"
					   FROM pdv_vd_it it
					  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND c.st_vd = 1::numeric AND it.tipo_imposto = 1::numeric) AS vlr_cupons_cancelados_issqn,
				( SELECT COALESCE(sum(it.vlr_desc_it + it.vlr_desc_tot_rat ), 0::numeric) AS "coalesce"
					   FROM pdv_vd_it it
					  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND it.st_it = 1::numeric AND c.st_vd = 0::numeric AND it.tipo_imposto = 0::numeric) AS vlr_desc_it,
				( SELECT COALESCE(sum(it.vlr_desc_it + it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
					   FROM pdv_vd_it it
					  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND it.st_it = 1::numeric AND c.st_vd = 0::numeric AND it.tipo_imposto = 1::numeric) AS vlr_desc_it_issqn,
				( SELECT COALESCE(sum(it.vlr_liq_it- it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
					   FROM pdv_vd_it it
					  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND it.st_it = 1::numeric AND c.st_vd = 0::numeric AND it.tipo_imposto = 1::numeric) AS vlr_to_issqn,
				( SELECT COALESCE(sum(it.vlr_liq_it), 0::numeric) AS "coalesce"
					   FROM pdv_vd_it it
					  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd AND it.st_it = 1::numeric AND c.st_vd = 0::numeric) AS vlr_liq_it,
			  ( SELECT COALESCE(sum(it.vlr_it * it.qt_it), 0::numeric) AS "coalesce"
					   FROM pdv_vd_it it
					  WHERE c.cd_emp = it.cd_emp AND c.cd_filial = it.cd_filial AND c.cd_vd = it.cd_vd) as vlr_vd_bruta 				  
			   FROM pdv_vd c
			  ORDER BY c.cd_emp, c.cd_filial, c.cd_cx, c.dt_vd) temp
		 LEFT JOIN v_pdv_cupom_tributos trib ON temp.cd_emp = trib.cd_emp AND temp.cd_filial = trib.cd_filial AND temp.cd_cx = trib.cd_cx AND temp.dt_cupom = trib.dt_cupom
		 LEFT JOIN pdv_pos_diaria_ecf pos_ecf ON temp.cd_emp = pos_ecf.cd_emp AND temp.cd_filial = pos_ecf.cd_filial AND temp.cd_cx = pos_ecf.cd_cx AND temp.dt_cupom = pos_ecf.dt_mov
		 LEFT JOIN v_pdv_cupom_tributos_taxas trib_taxas ON temp.cd_emp = trib_taxas.cd_emp AND temp.cd_filial = trib_taxas.cd_filial AND temp.cd_cx = trib_taxas.cd_cx AND temp.dt_cupom = trib_taxas.dt_cupom
	  GROUP BY temp.cd_emp, temp.cd_filial, temp.cd_cx, temp.dt_cupom, pos_ecf.cont_reducao_z, pos_ecf.cont_reinicio_op, pos_ecf.vl_gt_ini, pos_ecf.coo_fin, pos_ecf.vl_gt_fin, trib.vlr_subst_trib, trib.vlr_isentas, trib_taxas.vlr_tot_base_iss, trib.vlr_n_incidencia, trib.vlr_base_calc_icms, trib_taxas.vlr_imposto, trib.vlr_subst_trib_iss, trib.vlr_isentas_iss, trib.vlr_n_incidencia_iss, trib.vlr_base_calc_icms_iss, trib.vlr_imposto_iss, trib_taxas.tx_icms_it, trib_taxas.tipo_imposto, trib_taxas.vlr_tot_base;
	
	ALTER TABLE v_pdv_cupom_mapa_resumo_cx OWNER TO postgres;
	
	RAISE NOTICE 'View v_pdv_cupom_mapa_resumo_cx recriada.'; 
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();
